//
//  Adding_Events_to_CalendarsAppDelegate.m
//  Adding Events to Calendars
//
//  Created by Vandad Nahavandipoor on 24/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Adding_Events_to_CalendarsAppDelegate.h"

@implementation Adding_Events_to_CalendarsAppDelegate

@synthesize window = _window;

- (BOOL)    createEventWithTitle:(NSString *)paramTitle
                       startDate:(NSDate *)paramStartDate
                         endDate:(NSDate *)paramEndDate
             inCalendarWithTitle:(NSString *)paramCalendarTitle
              inCalendarWithType:(EKCalendarType)paramCalendarType
                           notes:(NSString *)paramNotes{
  
  BOOL result = NO;
  
  EKEventStore *eventStore = [[EKEventStore alloc] init];
  
  /* Czy w bazie danych kalendarzy znajdują się jakiekolwiek kalendarze? */
  if ([eventStore.calendars count] == 0){
    NSLog(@"Nie znaleziono żadnych kalendarzy.");
    return NO;
  }
  
  EKCalendar *targetCalendar = nil;
  
  /* Próba odszukania kalendarza żądanego przez użytkownika. */
  for (EKCalendar *thisCalendar in eventStore.calendars){
    if ([thisCalendar.title isEqualToString:paramCalendarTitle] &&
        thisCalendar.type == paramCalendarType){
      targetCalendar = thisCalendar;
      break;
    }
  }
  
  /* Upewniamy się, że znaleziony kalendarz to żądany przez użytkownika. */
  if (targetCalendar == nil){
    NSLog(@"Nie znaleziono żądanego kalendarza.");
    return NO;
  }
  
  /* Jeżeli kalendarz nie pozwala na modyfikacje jego zawartości,
   wówczas nie będzie można wstawiać do niego wydarzeń. */
  if (targetCalendar.allowsContentModifications == NO){
    NSLog(@"Wybrany kalendarz nie pozwala na przeprowadzanie modyfikacji.");
    return NO;
  }
  
  /* Utworzenie wydarzenia. */
  EKEvent *event = [EKEvent eventWithEventStore:eventStore];
  event.calendar = targetCalendar;
  
  /* Przypisanie wartości właściwościom wydarzenia, takim jak nazwa,
   data początkowa i końcowa, godzina początkowa i końcowa itd. */
  event.title = paramTitle;
  event.notes = paramNotes;
  event.startDate = paramStartDate;
  event.endDate = paramEndDate;
  
  /* Na końcu wydarzenie zostaje zapisane w kalendarzu. */
  NSError *saveError = nil;
  
  result = [eventStore saveEvent:event
                            span:EKSpanThisEvent
                           error:&saveError];
  
  if (result == NO){
    NSLog(@"Wystąpił błąd = %@", saveError);
  }
  
  return result;
  
}

- (BOOL)            application:(UIApplication *)application 
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  /* Wydarzenie rozpoczyna się dzisiaj, dokładnie w tej chwili. */
  NSDate *startDate = [NSDate date];
  
  /* Wydarzenie kończy się jutro, dokładnie o tej samej godzinie.
   24 godziny, 60 minut na godzinę i 60 sekund w ciągu minuty,
   stąd 24 * 60 * 60. */
  NSDate *endDate = [startDate
                     dateByAddingTimeInterval:24 * 60 * 60];
  
  /* Utworzenie wydarzenia. */
  BOOL createdSuccessfully = [self createEventWithTitle:@"Moje wydarzenie"
                                              startDate:startDate
                                                endDate:endDate
                                    inCalendarWithTitle:@"Calendar"
                                     inCalendarWithType:EKCalendarTypeLocal
                                                  notes:nil];
  
  if (createdSuccessfully){
    NSLog(@"Udało się utworzyć wydarzenie.");
  } else {
    NSLog(@"Nie udało się utworzyć wydarzenia.");
  }
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy aplikacja przechodzi ze stanu aktywnego do nieaktywnego. Może być wywołana w określonych sytuacjach (na przykład w chwili odbywania rozmowy telefonicznej lub po otrzymaniu wiadomości SMS) bądź kiedy użytkownik kończy działanie aplikacji. Metoda rozpoczyna proces przejścia do stanu pozostania w tle. Tę metodę można wykorzystać do wstrzymania wykonywania bieżących zadań, wyłączenia liczników czasu, zmniejszenia liczby klatek generowanych przez OpenGL ES. W grach ta metoda powinna być użyta do wstrzymania gry (pauza).
   */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
  /*
   W tej metodzie można wznowić działanie zadań zatrzymanych (lub nieuruchomionych), gdy aplikacja była nieaktywna. Jeżeli aplikacja znajdowała się w trybie działania w tle, w metodzie można przeprowadzić odświeżenie interfejsu użytkownika.
   */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy działanie aplikacji ma zostać zakończone. Zapoznaj się z opisem metody applicationDidEnterBackground:.
   */
}

@end
